@echo off
title Automated Proxmox Connection Launcher (VPN + RDP)
color 09

:: =================================================================
:: ==      FULLY PORTABLE AUTOMATED CONNECTION LAUNCHER           ==
:: =================================================================
:: This script is self-contained. It connects the correct VPN,
:: prompts for an IP, launches RDP, and cleans up everything.

:: --- Configuration --
:: Define the directory on the user's Desktop.
SET LAUNCHER_DIR=%USERPROFILE%\Desktop\Launcher

:: --- THIS IS THE UPDATED LINE ---
:: Path to the portable WireGuard executable inside the Launcher folder.
SET WG_EXE_PATH="%USERPROFILE%\Desktop\Launcher\WireGuard\wireguard.exe"
:: --------------------------------

:: --- Main Logic ---

:: Create the Launcher directory on the Desktop if it doesn't exist.
if not exist "%LAUNCHER_DIR%" (
    echo Creating launcher directory on your Desktop...
    mkdir "%LAUNCHER_DIR%"
)

:SELECT_SERVER
cls
echo.
echo =================================================================
echo  Please select the Proxmox Server Cluster to connect to:
echo =================================================================
echo.
echo  1. m32467 (Connects via tunnel: client1)
echo  2. m32486 (Connects via tunnel: client2)
echo  3. m32487 (Connects via tunnel: client3)
echo.

set "SERVER_CHOICE="
set /p SERVER_CHOICE="Enter your choice (1, 2, or 3): "

if "%SERVER_CHOICE%"=="1" SET WG_TUNNEL_NAME=client1
if "%SERVER_CHOICE%"=="2" SET WG_TUNNEL_NAME=client2
if "%SERVER_CHOICE%"=="3" SET WG_TUNNEL_NAME=client3

if not defined WG_TUNNEL_NAME (
    echo Invalid choice. Please try again.
    timeout /t 2 >nul
    goto SELECT_SERVER
)

:: Connect the selected WireGuard tunnel.
echo.
echo Connecting VPN tunnel "%WG_TUNNEL_NAME%"...
%WG_EXE_PATH% /installtunnelservice "%LAUNCHER_DIR%\%WG_TUNNEL_NAME%.conf"
timeout /t 5 >nul

:ENTER_IP
cls
echo.
echo =================================================================
echo  VPN CONNECTED. Now find the VM's IP address in Proxmox:
echo =================================================================
echo  1. Select your VM.
echo  2. Go to the "Summary" tab.
echo  3. Find the IP under "QEMU Guest Agent".
echo =================================================================
echo.

:: Prompt the user to enter the target IP address.
set "RDP_TARGET_IP="
set /p RDP_TARGET_IP=Enter the VM IP Address and press Enter: 

:: Validate that the user entered an IP.
if not defined RDP_TARGET_IP (
    echo No IP address entered. Aborting.
    pause
    goto CLEANUP
)

:: Define the full path for the temporary RDP file.
SET RDP_FILE_PATH=%LAUNCHER_DIR%\Connect-%RDP_TARGET_IP%.rdp

echo.
echo Adding secure credentials to Windows Vault...
:: Add credentials to Windows Credential Manager.
cmdkey /add:TERMSRV/%RDP_TARGET_IP% /user:user /pass:p@ssword

echo Generating connection file...
:: Dynamically generate the .rdp file.
(
    echo full address:s:%RDP_TARGET_IP%
    echo username:s:.\user
    echo screen mode id:i:2
    echo use multimon:i:1
    echo session bpp:i:32
    echo redirectclipboard:i:1
    echo authentication level:i:2
    echo enablecredsspsupport:i:1
) > "%RDP_FILE_PATH%"

echo Launching Remote Desktop session to %RDP_TARGET_IP%...
:: Launch the RDP session using the generated file.
start /wait mstsc.exe "%RDP_FILE_PATH%"

:CLEANUP
echo.
echo Session ended. Cleaning up...

:: Remove the temporary credentials from the vault.
cmdkey /delete:TERMSRV/%RDP_TARGET_IP% >nul 2>&1

:: Delete the temporary .rdp file.
if exist "%RDP_FILE_PATH%" del "%RDP_FILE_PATH%"

:: Disconnect the WireGuard tunnel.
echo Disconnecting VPN tunnel "%WG_TUNNEL_NAME%"...
%WG_EXE_PATH% /uninstalltunnelservice %WG_TUNNEL_NAME%

echo Cleanup complete.
timeout /t 3 >nul
exit /b