@echo off
title New Connection Launcher Creator
color 0B

:: =================================================================
:: ==            CONNECTION LAUNCHER CREATOR (v3)               ==
:: =================================================================
:: This script asks for connection details ONCE and generates a
:: permanent, one-click .bat file directly on your Desktop.

:: --- Define Global Paths ---
:: This is the folder where this script, WireGuard, and .conf files are.
SET LAUNCHER_DIR=%USERPROFILE%\Desktop\Launcher
SET WG_EXE_PATH=%LAUNCHER_DIR%\WireGuard\wireguard.exe

:: --- Ensure Directories Exist ---
if not exist "%LAUNCHER_DIR%" mkdir "%LAUNCHER_DIR%"
if not exist "%WG_EXE_PATH%" (
    echo.
    echo ERROR: WireGuard executable not found at:
    echo %WG_EXE_PATH%
    echo Please ensure wireguard.exe is placed correctly.
    pause
    exit /b
)

:: =================================================================
:: ==                      STEP 1: CHOOSE SERVER                  ==
:: =================================================================
:SERVER_CHOICE
cls
echo Please choose the target Proxmox Server Cluster:
echo -------------------------------------------------
echo 1. m32467 (Connects via WireGuard: client1)
echo 2. m32486 (Connects via WireGuard: client2)
echo 3. m32487 (Connects via WireGuard: client3)
echo -------------------------------------------------
echo.
set "CHOICE="
set /p CHOICE="Enter your choice (1, 2, or 3): "

if not defined CHOICE (goto SERVER_CHOICE)
if "%CHOICE%"=="1" set WG_CONFIG_NAME=client1
if "%CHOICE%"=="2" set WG_CONFIG_NAME=client2
if "%CHOICE%"=="3" set WG_CONFIG_NAME=client3
if not defined WG_CONFIG_NAME (
    echo Invalid choice. Please try again.
    timeout /t 2 >nul
    goto SERVER_CHOICE
)

:: =================================================================
:: ==              STEP 2: ENTER VM AND NAME DETAILS              ==
:: =================================================================
echo.
echo Please find the VM's IP address in Proxmox.
echo.
set "RDP_TARGET_IP="
set /p RDP_TARGET_IP="Enter the target VM IP Address: "
if not defined RDP_TARGET_IP (
    echo No IP address entered. Aborting.
    pause
    exit /b
)

echo.
set "FRIENDLY_NAME="
set /p FRIENDLY_NAME="Enter a friendly name for this launcher (e.g., Dev-VM-1): "
if not defined FRIENDLY_NAME set "FRIENDLY_NAME=Connection-%RDP_TARGET_IP%"

:: --- Define the output file path. This is the key change ---
:: Sanitize the friendly name to create a valid filename
SET LAUNCHER_FILENAME=Connect-%FRIENDLY_NAME: =_%.bat
:: Set the output path directly to the user's Desktop
SET NEW_LAUNCHER_PATH=%USERPROFILE%\Desktop\%LAUNCHER_FILENAME%

echo.
echo Creating new launcher on your Desktop: %LAUNCHER_FILENAME%
echo This may take a moment...

:: =================================================================
:: ==           STEP 3: GENERATE THE ONE-CLICK LAUNCHER           ==
:: =================================================================

:: Delete the file if it already exists to ensure a clean write
if exist "%NEW_LAUNCHER_PATH%" del "%NEW_LAUNCHER_PATH%"

:: Write the new launcher file line by line for reliability
>>"%NEW_LAUNCHER_PATH%" echo @echo off
>>"%NEW_LAUNCHER_PATH%" echo title Connecting to %FRIENDLY_NAME% (%RDP_TARGET_IP%)
>>"%NEW_LAUNCHER_PATH%" echo color 0A
>>"%NEW_LAUNCHER_PATH%" echo.
>>"%NEW_LAUNCHER_PATH%" echo :: This is an auto-generated one-click launcher. Do not edit.
>>"%NEW_LAUNCHER_PATH%" echo.
>>"%NEW_LAUNCHER_PATH%" echo :: --- Hardcoded Configuration ---
>>"%NEW_LAUNCHER_PATH%" echo SET RDP_TARGET_IP=%RDP_TARGET_IP%
>>"%NEW_LAUNCHER_PATH%" echo SET WG_CONFIG_NAME=%WG_CONFIG_NAME%
>>"%NEW_LAUNCHER_PATH%" echo SET LAUNCHER_DIR=%%USERPROFILE%%\Desktop\Launcher
>>"%NEW_LAUNCHER_PATH%" echo SET WG_EXE_PATH=%%LAUNCHER_DIR%%\WireGuard\wireguard.exe
>>"%NEW_LAUNCHER_PATH%" echo SET RDP_FILE_PATH=%%LAUNCHER_DIR%%\Connect-%%RDP_TARGET_IP%%.rdp
>>"%NEW_LAUNCHER_PATH%" echo.
>>"%NEW_LAUNCHER_PATH%" echo echo [1/5] Connecting WireGuard tunnel (%%WG_CONFIG_NAME%%)...
>>"%NEW_LAUNCHER_PATH%" echo start /b "" "%%WG_EXE_PATH%%" /installtunnelservice "%%LAUNCHER_DIR%%\%%WG_CONFIG_NAME%%.conf"
>>"%NEW_LAUNCHER_PATH%" echo timeout /t 5 ^>nul
>>"%NEW_LAUNCHER_PATH%" echo.
>>"%NEW_LAUNCHER_PATH%" echo echo [2/5] Adding secure credentials to Windows Vault...
>>"%NEW_LAUNCHER_PATH%" echo cmdkey /add:TERMSRV/%%RDP_TARGET_IP%% /user:.\user /pass:p@ssword
>>"%NEW_LAUNCHER_PATH%" echo.
>>"%NEW_LAUNCHER_PATH%" echo echo [3/5] Generating temporary RDP connection file...
>>"%NEW_LAUNCHER_PATH%" echo (
>>"%NEW_LAUNCHER_PATH%" echo   echo full address:s:%%RDP_TARGET_IP%%
>>"%NEW_LAUNCHER_PATH%" echo   echo username:s:.\user
>>"%NEW_LAUNCHER_PATH%" echo   echo screen mode id:i:2
>>"%NEW_LAUNCHER_PATH%" echo   echo use multimon:i:1
>>"%NEW_LAUNCHER_PATH%" echo   echo redirectclipboard:i:1
>>"%NEW_LAUNCHER_PATH%" echo   echo authentication level:i:2
>>"%NEW_LAUNCHER_PATH%" echo   echo enablecredsspsupport:i:1
>>"%NEW_LAUNCHER_PATH%" echo ) ^> "%%RDP_FILE_PATH%%"
>>"%NEW_LAUNCHER_PATH%" echo.
>>"%NEW_LAUNCHER_PATH%" echo echo [4/5] Launching Remote Desktop session...
>>"%NEW_LAUNCHER_PATH%" echo start /wait mstsc.exe "%%RDP_FILE_PATH%%"
>>"%NEW_LAUNCHER_PATH%" echo.
>>"%NEW_LAUNCHER_PATH%" echo echo [5/5] Session ended. Cleaning up...
>>"%NEW_LAUNCHER_PATH%" echo cmdkey /delete:TERMSRV/%%RDP_TARGET_IP%%
>>"%NEW_LAUNCHER_PATH%" echo del "%%RDP_FILE_PATH%%"
>>"%NEW_LAUNCHER_PATH%" echo start /b "" "%%WG_EXE_PATH%%" /uninstalltunnelservice %%WG_CONFIG_NAME%%
>>"%NEW_LAUNCHER_PATH%" echo.
>>"%NEW_LAUNCHER_PATH%" echo echo Cleanup complete. Have a great day!
>>"%NEW_LAUNCHER_PATH%" echo timeout /t 3 ^>nul
>>"%NEW_LAUNCHER_PATH%" echo exit /b

:: --- Verify file creation ---
if not exist "%NEW_LAUNCHER_PATH%" (
    cls
    echo.
    echo ================================================================
    echo ERROR: FAILED TO CREATE THE LAUNCHER FILE!
    echo ================================================================
    echo.
    echo Please check the permissions for your Desktop folder.
    echo The script was unable to write the file to:
    echo %NEW_LAUNCHER_PATH%
    echo.
    pause
    exit /b
)

cls
echo.
echo ===============================================
echo      SUCCESS! A new launcher was created.
echo ===============================================
echo.
echo File Name: %LAUNCHER_FILENAME%
echo Location:  Your Desktop
echo.
echo You can now double-click the new file on your Desktop
echo anytime to connect directly to %FRIENDLY_NAME%.
echo.
pause
exit /b